import os
import gzip
from Bio import SeqIO

directory = "/osc-fs_home/mdehoon/Data/CASPARs/HiSeq/Fastq"
filenames = sorted(os.listdir(directory))
for filename in filenames:
    path = os.path.join(directory, filename)
    n = 0
    stream = gzip.open(path, 'rt')
    records = SeqIO.parse(stream, 'fastq')
    for record in records: 
        n += 1
    stream.close()
    print(filename, n) 
